<?php
// Gestion du proxy - DEBUT
$sFichierProxys     = 'scrap_google_proxys.txt';
// Si un proxy ou des proxys doivent etre utilises, renseigner les infos dans le fichier ci dessus
//   Format : ip:port:login:mdp
//   1 proxy par ligne
// Si pas de proxy, laisser le fichier vide
$sProxyIpPort       = '';
$sProxyLoginMdp     = '';
if(@file_exists($sFichierProxys))
{
    $aProxys = @file($sFichierProxys, FILE_SKIP_EMPTY_LINES);
    
    if(!empty($aProxys) ||!is_array($aProxys))
    {
        echo count($aProxys)." proxys trouves dans le fichier ".$sFichierProxys."<br />";
    
        $rand_keys          = array_rand($aProxys);
        $aProxy             = explode(':', $aProxys[$rand_keys]);
        $sProxyLoginMdp     = $aProxy[2].':'.$aProxy[3];
        $sProxyIpPort       = $aProxy[0].':'.$aProxy[1];
    }
}
if(!empty($sProxyIpPort) && !empty($sProxyLoginMdp)){echo "Proxy ".$sProxyIpPort." utilisé<br /><br />";}else{echo "Pas de <a href=\"http://buyproxies.org/panel/aff.php?aff=2493\" target=\"_blank\">proxy</a> utilisé<br /><br />";}
// Gestion du proxy - FIN

// URL google a curler
// on peut changer le nombre de resultats affiches en modifiant le parametre num=. Valeurs possibles : 10, 30, 50, 100
$surlGoogle = 'https://www.google.fr/search?hl=fr&ie=utf-8&num=50&q=';

// navigateurs desktop / mobile (UA)
$aNavigateurs = array(
    "desktop"   => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.84 Safari/537.36",
    "mobile"    =>"Mozilla/5.0 (iPhone; CPU iPhone OS 6_0 like Mac OS X) AppleWebKit/536.26 (KHTML, like Gecko) Version/6.0 Mobile/10A403 Safari/8536.25"
);

// Tableau qui contient les xPath des différents elements que l'on va recuperer dans la SERP
$aXpath = array(
'desktop'            =>  array(
    'urls'          => '//div[@id="ires"]//h3[@class="r"]/a/@href', 
    'titles'        => '//div[@id="ires"]//h3[@class="r"]/a',
    'snippets'      => '//span[@class="st"]'
    ), 
'mobile' =>  array(
    'urls'          => '//a[@class="_Olt _bCp"]/@href', 
    'titles'        => '//div[@class="_H1m _ees"]',
    'snippets'      => '//div[@class="_H1m"]'
    )
);

// temps d'attente entre deux check de mot clef (en secondes)
// Pour augmenter le délai, modifier la valeur (par défaut : 2)
// Attention à ne pas trop augmenter car le check de beaucoup de mots clefs risque d'entrainer un timeout de la page
$iDelai = 2;

// GESTION DES MOTS CLEFS - DEBUT
// Fichier texte qu'il faudra creer au meme niveau que ce script (= dans le meme repertoire)
// Il devra contenir 1 mot clef par ligne (encodage utf8)
$sFichierKeywords   = 'scrap_google_keywords.txt';

//Recuperation des mots clef dans le fichier texte
if (!file_exists($sFichierKeywords)) {die("Le fichier '".$sFichierKeywords."' n'existe pas sur le serveur");}
$aKeywords = @file($sFichierKeywords, FILE_SKIP_EMPTY_LINES);
if(empty($aKeywords) || !is_array($aKeywords)){die("Le fichier ".$sFichierKeywords." doit contenir au moins 1 mot clef (si plusieurs mots clefs : 1 par ligne) - ARRET DU SCRIPT");}
echo count($aKeywords)." mots clefs trouves dans le fichier ".$sFichierKeywords."<br />";
// GESTION DES MOTS CLEFS - FIN 
 

// Par defaut, c'est google Desktop qui sera curlé
// si on rajoute dans la barre d'adresse du navigateur ?mobile=mobile, ce sera la version mobile
$sVersion = 'desktop';
if(isset($_GET['mobile']) && $_GET['mobile']=='mobile'){$sVersion = 'mobile';}
echo "C'est la Version ".$sVersion." de Google qui va etre lue avec l'UA : ".$aNavigateurs[$sVersion]."<br /><br />";

require_once 'scrap_google_functions.php';

$bufferGlobalCsv = "DATE|POSITION|MOT CLEF|URL|BALISE TITLE|META DESCRIPTION\n";

// Pour chaque mot clef : cUrl + recuperation des informations
foreach($aKeywords as $value)
{
    $value = trim($value);
    if(!empty($value) & strlen($value)>1)
    {        
        $result = CurlInfo($surlGoogle.urlencode($value),$aNavigateurs[$sVersion], $sProxyIpPort, $sProxyLoginMdp);  
        if(empty($result) || $result==false)
        {
            die(' /!\ Pas de resutat au scrap de '.$surlGoogle.urlencode($value).' /!\ <br /> /!\ Probablement IP serveur (utiliser un proxy) ou IP du proxy (<a href="http://buyproxies.org/panel/aff.php?aff=2493" target="_blank">changer de proxy</a>) blacklistee /!\  - ARRET DU SCRIPT');
        }
        echo "<hr />- Scrap du mot clef '".$value."' OK a cette URL : <a href=\"".$surlGoogle.$value."\" target=\"_blank\">".$surlGoogle.$value."</a><br />";
        $sFilenameCache = date("Y-m-d").'_'.$value.'_'.$sVersion.'.html';
        @file_put_contents($sFilenameCache, $result);
        echo "-- SERP enregistree <a href=\"".$sFilenameCache."\" target=\"_blank\">ici</a> <br />";
        
        //pour Chaque element
        foreach($aXpath[$sVersion] as $key2 => $value2)
        {
            // recuperation et export des URL de la SERP
            if($key2 == 'urls')
            {
                $aUrlResults                = getDomValue($value2, $result);
                if(!empty($aUrlResults) && $aUrlResults!=false)
                {
                    foreach($aUrlResults as $valueU)
                    {
                        $aBufferUrl[] = GoogleUrlsSerpsFix($valueU);
                    }
                }
            }
            
            // recuperation et export des title de la SERP
            if($key2 == 'titles')
            {
                $aTitleResults              = getDomValue($value2, $result);
                if(!empty($aTitleResults) && $aTitleResults!=false)
                {
                    foreach($aTitleResults as $valueT)
                    {
                        $aBufferTitle[] = str_replace("\n", " ", $valueT);
                    } 
                }
            }
            
            // recuperation et export des snippets de la SERP
            if($key2 == 'snippets')
            {
                $aSnippetsResults           = getDomValue($value2, $result);
                if(!empty($aSnippetsResults) && $aSnippetsResults!=false)
                {
                    foreach($aSnippetsResults as $valueS)
                    {
                        $aBufferSnippets[] = str_replace("\n", " ", str_replace("\n", " ", $valueS));
                    }
                }
            }
        }

        //on enregistre toutes les infos recuperees dans les serp pour ce mot clef
        $i=0;
        foreach($aBufferUrl as $valueBuff)
        {
            $bufferGlobalCsv.= date("Y-m-d")."|".($i+1)."|".$value."|".$valueBuff."|".str_replace("|", " ", $aBufferTitle[$i])."|".str_replace("|", " ", $aBufferSnippets[$i])."\n";
            $i++;
        }
        
        unset($result);
        unset($valueBuff);
        unset($aBufferUrl);
        unset($aBufferTitle);
        unset($aBufferSnippets);
        //pause
        sleep($iDelai);
    }
}
$sFilenameGlobal  = date("Y-m-d").'_'.$sVersion.'.csv';
@file_put_contents($sFilenameGlobal, $bufferGlobalCsv);
echo "<hr />Fichier csv global enregistre <a href=\"".$sFilenameGlobal."\" target=\"_blank\">ici</a>";
echo "<hr><strong><a href=\"http://buyproxies.org/panel/aff.php?aff=2493\" target=\"_blank\">Service de location de proxys Byuproxies recommandé</a></strong> (lien affi). Plus d'informations sur <a href=\"http://www.jeromeweb.net/php/20913-script-curl-google-fr#Proxys\" target=\"_blank\">jeromeweb.net/php/20913-script-curl-google-fr#Proxys</a><br /><br />";
echo "<strong>Logiciels recommandés : </strong><ul><li>Rank tracker de SEO Powersuite : logiciel de check de positions d'un site web. Un article complet en parle sur cette page : <a href=\"http://www.jeromeweb.net/outil-seo-rank-tracker\" target=\"_blank\">jeromeweb.net/outil-seo-rank-tracker</a></li><li>Ranxplorer : outil de suivi de mots clefs (permet d'analyser les concurrents). Un article complet en parle sur cette page : <a href=\"http://www.jeromeweb.net/interview/20461-pierre-ranxplorer\" target=\"_blank\">jeromeweb.net/interview/20461-pierre-ranxplorer</a></li><li><a href=\"http://buy.rddz-tools.com/aff/go?r=140&i=3\" target=\"_blank\">RDDZ Scraper</a> : Scrapper multi fonctions, idéal pour scraper Google et les autres moteurs (lien affi)</li></ul>"
?>