<?php
/**
 * cUrl et gestion des proxys
 *
 * @param array $sUrl URL a cUrler
 * @param string $sNavigateur user agent
 * @param string $sProxyIpPort Adresse du proxy et port du proxy. Format IP:PORT
 * @param string $sProxyLoginMdp Login et mot de passe du proxy. Format LOGIN:MDP
 *
 * @return string|false   resultat de l'url curlee (code html)
 */
function CurlInfo($sUrl = '', $sNavigateur='', $sProxyIpPort='', $sProxyLoginMdp='')
{
    if(empty($sUrl) && strlen($sUrl)<10)
    {
        die("PROBLEME avec l'url a cUrler - ARRET DU SCRIPT");
    }
    $curl = curl_init();

    if(!empty($sProxyIpPort) && !empty($sProxyLoginMdp))
    {
        // Activation de l'utilisation d'un serveur proxy
        curl_setopt($curl, CURLOPT_HTTPPROXYTUNNEL, true);
        // Définition de l'adresse du proxy
        curl_setopt($curl, CURLOPT_PROXY, $sProxyIpPort);
        // Définition des identifiants si le proxy requiert une identification
        curl_setopt($curl, CURLOPT_PROXYUSERPWD, $sProxyLoginMdp);
    }

    // Forcer l'utilisation d'une nouvelle connexion (pas de cache) 
    curl_setopt($curl, CURLOPT_FRESH_CONNECT, true); 
    // Definition du timeout de la requete (en secondes) 
    curl_setopt($curl, CURLOPT_TIMEOUT, 5); 
    curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($curl, CURLOPT_FAILONERROR, 1);	
    //suit les redirections
    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1); 
    //desactive l'affichage direct dans le navigateur
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); 
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); 
    // Indique que le navigateur accepte le FR : permet de forcer les resultats FR sur google.fr,
    curl_setopt($curl, CURLOPT_HTTPHEADER, ['Accept-Language: fr']);
    // force nouveau cookie de session
    curl_setopt($curl, CURLOPT_COOKIESESSION, true);
    //navigateur
    curl_setopt($curl, CURLOPT_USERAGENT, $sNavigateur);

    // Definir l'adresse a ouvrir
    curl_setopt($curl, CURLOPT_URL, $sUrl);

    // Executer le CURL
    $result = curl_exec($curl);
    
    return $result;
}

/**
 * nettoie les URL des SERP de /url?q=https://www.jeromeweb.net/&sa=U&ved=0ahUKEwjMrPaTtrzZAhVB7BQKHRHfDU8QFggUMAA&usg=AOvVaw2AZ2SehKpTvA-Y3ef3rrgx à https://www.jeromeweb.net
 *
 * @param string $path syntaxe xpath
 * @param string $html chaine a analyser (= page)
 * @return array
 */
function getDomValue($path, $html)
{
        $dom 		= new DOMDocument();
        @$dom->loadHTML($html);

        $xp 		= new DOMXPath($dom);
        $nodeList	= $xp->query($path);

        foreach($nodeList as $domElement)
        {
                if(!empty($domElement->nodeValue))
                {
                        $aResultsDom[] = $domElement->nodeValue;
                }
        }
        return $aResultsDom;
}

/**
 * nettoie les URL des SERP de /url?q=https://www.jeromeweb.net/&sa=U&ved=0ahUKEwjMrPaTtrzZAhVB7BQKHRHfDU8QFggUMAA&usg=AOvVaw2AZ2SehKpTvA-Y3ef3rrgx à https://www.jeromeweb.net
 *
 * @param string $sUrls URL Google SERP
 * @return string|false   resultat de l'url nettoyee
 */
function GoogleUrlsSerpsFix($sUrls='')
{
    if(empty($sUrls))
    {
        return false;
    }
    $sUrls  = ltrim($sUrls, '/url?q=');
    $aUrls = explode('&', $sUrls);

    $sUrls  = urldecode($aUrls[0]);
    return $sUrls;           
}
?>